local tunnel={}
local shader
local active=false
local hueFadeProgress=0
function tunnel.load()
shader=love.graphics.newShader([[
extern float time;
extern float hueFade;
vec4 effect(vec4 color, Image texture, vec2 texture_coords, vec2 screen_coords) {
vec2 uv=(screen_coords.xy/love_ScreenSize.xy)-0.5;
uv.y*=love_ScreenSize.y/love_ScreenSize.x;
float angle=atan(uv.y,uv.x);
float radius=length(uv);
float stripes=sin((radius*10.0)-(time*5.0));
float intensity=(stripes+1.0)*0.5;
vec3 startColor=vec3(0.2,0.0,0.7);
vec3 endColor=vec3(0.7,0.0,0.0);
vec3 tunnelColor=mix(startColor,endColor,hueFade);
vec3 blendColor=mix(vec3(1.0),vec3(0.0),hueFade);
tunnelColor=mix(tunnelColor,blendColor,intensity);
return vec4(tunnelColor,1.0)*color; } ]])
end
function tunnel.update(dt,timePassed)
if timePassed>=24.6 and timePassed<39.6 then
active=true
if timePassed>=32.1 and timePassed<=32.6 then
hueFadeProgress=(timePassed-32.1)/0.5
elseif timePassed>32.6 then
hueFadeProgress=1
end
else
active=false
hueFadeProgress=0
end end
function tunnel.draw()
if active and shader then
love.graphics.setShader(shader)
shader:send("time",love.timer.getTime())
shader:send("hueFade",hueFadeProgress)
love.graphics.setColor(1,1,1,0.33)
love.graphics.rectangle("fill",0,0,love.graphics.getWidth(),love.graphics.getHeight())
love.graphics.setShader()
end end
return tunnel
